(function($, task) {
"use strict";

function Events1() { // poll 

	function on_page_loaded(task) {
		
		$("title").text(task.item_caption);
		$("#title").text(task.item_caption);
		  
		if (task.safe_mode) {
			$("#user-info").text(task.user_info.role_name + ' ' + task.user_info.user_name);
			$('#log-out')
			.show() 
			.click(function(e) {
				e.preventDefault();
				task.logout();
			}); 
		}
	
		if (task.full_width) {
			$('#container').removeClass('container').addClass('container-fluid');
		}
		$('#container').show();
		
		task.create_menu($("#menu"), $("#content"), {
			// splash_screen: '<h1 class="text-center">Application</h1>',
			view_first: true
		});
	
		// $(document).ajaxStart(function() { $("html").addClass("wait"); });
		// $(document).ajaxStop(function() { $("html").removeClass("wait"); });
	} 
	
	function on_view_form_created(item) {
		var table_options_height = item.table_options.height,
			table_container;
	
		item.clear_filters();
		
		item.view_options.table_container_class = 'view-table';
		item.view_options.detail_container_class = 'view-detail';
		item.view_options.open_item = true;
		
		if (item.view_form.hasClass('modal')) {
			item.view_options.width = 1060;
			item.table_options.height = $(window).height() - 300;
		}
		else {
			if (!item.table_options.height) {
				item.table_options.height = $(window).height() - $('body').height() - 20;
			}
		}
		
		if (item.can_create()) {
			item.view_form.find("#new-btn").on('click.task', function(e) {
				e.preventDefault();
				if (item.master) {
					item.append_record();
				}
				else {
					item.insert_record();
				}
			});
		}
		else {
			item.view_form.find("#new-btn").prop("disabled", true);
		}
	
		item.view_form.find("#edit-btn").on('click.task', function(e) {
			e.preventDefault();
			item.edit_record();
		});
	
		if (item.can_delete()) {
			item.view_form.find("#delete-btn").on('click.task', function(e) {
				e.preventDefault();
				item.delete_record();
			});
		}
		else {
			item.view_form.find("#delete-btn").prop("disabled", true);
		}
		
		create_print_btns(item);
	
		task.view_form_created(item);
		
		if (!item.master && item.owner.on_view_form_created) {
			item.owner.on_view_form_created(item);
		}
	
		if (item.on_view_form_created) {
			item.on_view_form_created(item);
		}
		
		item.create_view_tables();
		
		if (!item.master && item.view_options.open_item) {
			item.open(true);
		}
	
		if (!table_options_height) {
			item.table_options.height = undefined;
		}
		return true;
	}
	
	function on_view_form_shown(item) {
		item.view_form.find('.dbtable.' + item.item_name + ' .inner-table').focus();
	}
	
	function on_view_form_closed(item) {
		if (!item.master && item.view_options.open_item) {	
			item.close();
		}
	}
	
	function on_edit_form_created(item) {
		item.edit_options.inputs_container_class = 'edit-body';
		item.edit_options.detail_container_class = 'edit-detail';
		
		item.edit_form.find("#cancel-btn").on('click.task', function(e) { item.cancel_edit(e) });
		item.edit_form.find("#ok-btn").on('click.task', function() { item.apply_record() });
		if (!item.is_new() && !item.can_modify) {
			item.edit_form.find("#ok-btn").prop("disabled", true);
		}
		
		task.edit_form_created(item);
		
		if (!item.master && item.owner.on_edit_form_created) {
			item.owner.on_edit_form_created(item);
		}
	
		if (item.on_edit_form_created) {
			item.on_edit_form_created(item);
		}
			
		item.create_inputs(item.edit_form.find('.' + item.edit_options.inputs_container_class));
		item.create_detail_views(item.edit_form.find('.' + item.edit_options.detail_container_class));
	
		return true;
	}
	
	function on_edit_form_close_query(item) {
		var result = true;
		if (item.is_changing()) {
			if (item.is_modified()) {
				item.yes_no_cancel(task.language.save_changes,
					function() {
						item.apply_record();
					},
					function() {
						item.cancel_edit();
					}
				);
				result = false;
			}
			else {
				item.cancel_edit();
			}
		}
		return result;
	}
	
	function on_filter_form_created(item) {
		item.filter_options.title = item.item_caption + ' - filters';
		item.create_filter_inputs(item.filter_form.find(".edit-body"));
		item.filter_form.find("#cancel-btn").on('click.task', function() {
			item.close_filter_form(); 
		});
		item.filter_form.find("#ok-btn").on('click.task', function() { 
			item.set_order_by(item.view_options.default_order);
			item.apply_filters(item._search_params); 
		});
	}
	
	function on_param_form_created(item) {
		item.create_param_inputs(item.param_form.find(".edit-body"));
		item.param_form.find("#cancel-btn").on('click.task', function() { 
			item.close_param_form();
		});
		item.param_form.find("#ok-btn").on('click.task', function() { 
			item.process_report();
		});
	}
	
	function on_before_print_report(report) {
		var select;
		report.extension = 'pdf';
		if (report.param_form) {
			select = report.param_form.find('select');
			if (select && select.val()) {
				report.extension = select.val();
			}
		}
	}
	
	function on_view_form_keyup(item, event) {
		if (event.keyCode === 45 && event.ctrlKey === true){
			if (item.master) {
				item.append_record();
			}
			else {
				item.insert_record();				
			}
		}
		else if (event.keyCode === 46 && event.ctrlKey === true){
			item.delete_record(); 
		}
	}
	
	function on_edit_form_keyup(item, event) {
		if (event.keyCode === 13 && event.ctrlKey === true){
			item.edit_form.find("#ok-btn").focus(); 
			item.apply_record();
		}
	}
	
	function create_print_btns(item) {
		var i,
			$ul,
			$li,
			reports = [];
		if (item.reports) {
			for (i = 0; i < item.reports.length; i++) {
				if (item.reports[i].can_view()) {
					reports.push(item.reports[i]);
				}
			}
			if (reports.length) {
				$ul = item.view_form.find("#report-btn ul");
				for (i = 0; i < reports.length; i++) {
					$li = $('<li><a href="#">' + reports[i].item_caption + '</a></li>');
					$li.find('a').data('report', reports[i]);
					$li.on('click', 'a', function(e) {
						e.preventDefault();
						$(this).data('report').print(false);
					});
					$ul.append($li);
				}
			}
			else {
				item.view_form.find("#report-btn").hide();
			}
		}
		else {
			item.view_form.find("#report-btn").hide();
		}
	}
	this.on_page_loaded = on_page_loaded;
	this.on_view_form_created = on_view_form_created;
	this.on_view_form_shown = on_view_form_shown;
	this.on_view_form_closed = on_view_form_closed;
	this.on_edit_form_created = on_edit_form_created;
	this.on_edit_form_close_query = on_edit_form_close_query;
	this.on_filter_form_created = on_filter_form_created;
	this.on_param_form_created = on_param_form_created;
	this.on_before_print_report = on_before_print_report;
	this.on_view_form_keyup = on_view_form_keyup;
	this.on_edit_form_keyup = on_edit_form_keyup;
	this.create_print_btns = create_print_btns;
}

task.events.events1 = new Events1();

function Events6() { // poll.catalogs.questions 

	function on_view_form_created(item) {
		showPollForm(item);
	
		// Function to display the poll form
		function showPollForm(item) {
			const pollTemplate = task.templates.find(".poll-form").clone();
			item.view_form.empty().append(pollTemplate);
	
			// Fetch questions from the server
			item.server("get_questions", function(questions, error) {
				if (error) {
					console.error("Error fetching questions:", error);
					return;
				}
	
				const questionsContainer = pollTemplate.find(".poll-questions");
				questions.forEach((q, index) => {
					let questionHtml = `<div class="question" data-question-id="${q.id}">
						<strong>Q${index + 1}: ${q.question_text}</strong><br>`;
					const options = q.options.split(",");
					options.forEach(option => {
						questionHtml += `
							<label style="margin-left: 20px;">
								<input type="radio" name="answer_${q.id}" value="${option.trim()}"> ${option.trim()}
							</label><br>`;
					});
					questionHtml += `</div><hr>`;
					questionsContainer.append(questionHtml);
				});
	
				// Handle poll submission
				pollTemplate.find("#submit-poll").on("click", function() {
					let responses = [];
					pollTemplate.find(".question").each(function() {
						const questionId = $(this).data("question-id");
						const selectedAnswer = $(this).find(`input[name="answer_${questionId}"]:checked`).val();
						if (selectedAnswer) {
							responses.push({ question_id: questionId, answer: selectedAnswer });
						}
					});
	
					if (responses.length === questions.length) {
						console.log("Responses being sent:", responses);
						item.server("save_responses", [responses], function(response, error) {
							if (error) {
								console.error("Error saving responses:", error);
								alert("Failed to submit poll!");
							} else {
								alert("Poll submitted successfully!");
								showResults(item);
							}
						});
					} else {
						alert("Please answer all questions!");
					}
				});
	
				// Switch to results view
				pollTemplate.find("#view-results").on("click", function() {
					showResults(item);
				});
			});
		}
	
		// Function to display poll results
		function showResults(item) {
			const resultsTemplate = task.templates.find(".poll-results").clone();
			item.view_form.empty().append(resultsTemplate);
	
			item.server("get_poll_results", function(results, error) {
				if (error) {
					console.error("Error fetching results:", error);
					return;
				}
	
				const resultsContainer = resultsTemplate.find(".results-container");
				results.forEach(result => {
					const canvas = $("<canvas>").attr("id", `chart_${result.question_id}`).css("max-width", "400px");
					resultsContainer.append(`<h3>${result.question_text}</h3>`);
					resultsContainer.append(canvas);
	
					// Create chart using Chart.js
					new Chart(canvas, {
						type: "bar",
						data: {
							labels: Object.keys(result.answers),
							datasets: [{
								label: "Votes",
								data: Object.values(result.answers),
								backgroundColor: "rgba(54, 162, 235, 0.5)",
								borderColor: "rgba(54, 162, 235, 1)",
								borderWidth: 1
							}]
						},
						options: {
							scales: {
								y: { beginAtZero: true, title: { display: true, text: "Number of Votes" } }
							},
							plugins: { legend: { display: false } }
						}
					});
				});
	
				// Back to poll button
				resultsTemplate.find("#back-to-poll").on("click", function() {
					showPollForm(item);
				});
			});
		}
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events6 = new Events6();

})(jQuery, task)