(function($, task) {
"use strict";

function Events1() { // jam_forum 

	function on_page_loaded(task) {
		
		$("title").text(task.item_caption);
		$("#title").text(task.item_caption);
		  
		if (task.safe_mode) {
			$("#user-info").text(task.user_info.role_name + ' ' + task.user_info.user_name);
			$('#log-out')
			.show() 
			.click(function(e) {
				e.preventDefault();
				task.logout();
			}); 
		}
	
		if (task.full_width) {
			$('#container').removeClass('container').addClass('container-fluid');
		}
		$('#container').show();
		
		task.create_menu($("#menu"), $("#content"), {
			// splash_screen: '<h1 class="text-center">Application</h1>',
			view_first: true
		});
	
		// $(document).ajaxStart(function() { $("html").addClass("wait"); });
		// $(document).ajaxStop(function() { $("html").removeClass("wait"); });
	} 
	
	function on_view_form_created(item) {
		var table_options_height = item.table_options.height,
			table_container;
	
		item.clear_filters();
		
		item.view_options.table_container_class = 'view-table';
		item.view_options.detail_container_class = 'view-detail';
		item.view_options.open_item = true;
		
		if (item.view_form.hasClass('modal')) {
			item.view_options.width = 1060;
			item.table_options.height = $(window).height() - 300;
		}
		else {
			if (!item.table_options.height) {
				item.table_options.height = $(window).height() - $('body').height() - 20;
			}
		}
		
		if (item.can_create()) {
			item.view_form.find("#new-btn").on('click.task', function(e) {
				e.preventDefault();
				if (item.master) {
					item.append_record();
				}
				else {
					item.insert_record();
				}
			});
		}
		else {
			item.view_form.find("#new-btn").prop("disabled", true);
		}
	
		item.view_form.find("#edit-btn").on('click.task', function(e) {
			e.preventDefault();
			item.edit_record();
		});
	
		if (item.can_delete()) {
			item.view_form.find("#delete-btn").on('click.task', function(e) {
				e.preventDefault();
				item.delete_record();
			});
		}
		else {
			item.view_form.find("#delete-btn").prop("disabled", true);
		}
		
		create_print_btns(item);
	
		task.view_form_created(item);
		
		if (!item.master && item.owner.on_view_form_created) {
			item.owner.on_view_form_created(item);
		}
	
		if (item.on_view_form_created) {
			item.on_view_form_created(item);
		}
		
		item.create_view_tables();
		
		if (!item.master && item.view_options.open_item) {
			item.open(true);
		}
	
		if (!table_options_height) {
			item.table_options.height = undefined;
		}
		return true;
	}
	
	function on_view_form_shown(item) {
		item.view_form.find('.dbtable.' + item.item_name + ' .inner-table').focus();
	}
	
	function on_view_form_closed(item) {
		if (!item.master && item.view_options.open_item) {	
			item.close();
		}
	}
	
	function on_edit_form_created(item) {
		item.edit_options.inputs_container_class = 'edit-body';
		item.edit_options.detail_container_class = 'edit-detail';
		
		item.edit_form.find("#cancel-btn").on('click.task', function(e) { item.cancel_edit(e) });
		item.edit_form.find("#ok-btn").on('click.task', function() { item.apply_record() });
		if (!item.is_new() && !item.can_modify) {
			item.edit_form.find("#ok-btn").prop("disabled", true);
		}
		
		task.edit_form_created(item);
		
		if (!item.master && item.owner.on_edit_form_created) {
			item.owner.on_edit_form_created(item);
		}
	
		if (item.on_edit_form_created) {
			item.on_edit_form_created(item);
		}
			
		item.create_inputs(item.edit_form.find('.' + item.edit_options.inputs_container_class));
		item.create_detail_views(item.edit_form.find('.' + item.edit_options.detail_container_class));
	
		return true;
	}
	
	function on_edit_form_close_query(item) {
		var result = true;
		if (item.is_changing()) {
			if (item.is_modified()) {
				item.yes_no_cancel(task.language.save_changes,
					function() {
						item.apply_record();
					},
					function() {
						item.cancel_edit();
					}
				);
				result = false;
			}
			else {
				item.cancel_edit();
			}
		}
		return result;
	}
	
	function on_filter_form_created(item) {
		item.filter_options.title = item.item_caption + ' - filters';
		item.create_filter_inputs(item.filter_form.find(".edit-body"));
		item.filter_form.find("#cancel-btn").on('click.task', function() {
			item.close_filter_form(); 
		});
		item.filter_form.find("#ok-btn").on('click.task', function() { 
			item.set_order_by(item.view_options.default_order);
			item.apply_filters(item._search_params); 
		});
	}
	
	function on_param_form_created(item) {
		item.create_param_inputs(item.param_form.find(".edit-body"));
		item.param_form.find("#cancel-btn").on('click.task', function() { 
			item.close_param_form();
		});
		item.param_form.find("#ok-btn").on('click.task', function() { 
			item.process_report();
		});
	}
	
	function on_before_print_report(report) {
		var select;
		report.extension = 'pdf';
		if (report.param_form) {
			select = report.param_form.find('select');
			if (select && select.val()) {
				report.extension = select.val();
			}
		}
	}
	
	function on_view_form_keyup(item, event) {
		if (event.keyCode === 45 && event.ctrlKey === true){
			if (item.master) {
				item.append_record();
			}
			else {
				item.insert_record();				
			}
		}
		else if (event.keyCode === 46 && event.ctrlKey === true){
			item.delete_record(); 
		}
	}
	
	function on_edit_form_keyup(item, event) {
		if (event.keyCode === 13 && event.ctrlKey === true){
			item.edit_form.find("#ok-btn").focus(); 
			item.apply_record();
		}
	}
	
	function create_print_btns(item) {
		var i,
			$ul,
			$li,
			reports = [];
		if (item.reports) {
			for (i = 0; i < item.reports.length; i++) {
				if (item.reports[i].can_view()) {
					reports.push(item.reports[i]);
				}
			}
			if (reports.length) {
				$ul = item.view_form.find("#report-btn ul");
				for (i = 0; i < reports.length; i++) {
					$li = $('<li><a href="#">' + reports[i].item_caption + '</a></li>');
					$li.find('a').data('report', reports[i]);
					$li.on('click', 'a', function(e) {
						e.preventDefault();
						$(this).data('report').print(false);
					});
					$ul.append($li);
				}
			}
			else {
				item.view_form.find("#report-btn").hide();
			}
		}
		else {
			item.view_form.find("#report-btn").hide();
		}
	}
	this.on_page_loaded = on_page_loaded;
	this.on_view_form_created = on_view_form_created;
	this.on_view_form_shown = on_view_form_shown;
	this.on_view_form_closed = on_view_form_closed;
	this.on_edit_form_created = on_edit_form_created;
	this.on_edit_form_close_query = on_edit_form_close_query;
	this.on_filter_form_created = on_filter_form_created;
	this.on_param_form_created = on_param_form_created;
	this.on_before_print_report = on_before_print_report;
	this.on_view_form_keyup = on_view_form_keyup;
	this.on_edit_form_keyup = on_edit_form_keyup;
	this.create_print_btns = create_print_btns;
}

task.events.events1 = new Events1();

function Events7() { // jam_forum.journals.topics 

	function on_view_form_created(item) {
		console.log("on_view_form_created executed");
		let forumContainer = $("#forum-container");  // Adjust if necessary to match your layout
	
		function renderTopics() {
			item.server("get_all_topics", function (topics, error) {
				if (error) return console.error("Error fetching topics:", error);
				let topicList = $("#topic-list");
				topicList.empty();
				topics.forEach(topic => {
					let topicElement = $("<li>")
						.addClass("list-group-item forum-topic")
						.text(topic.title)
						.data("topic-id", topic.id)
						.click(() => loadPosts(topic.id));  // Click loads posts but doesn't hide topics
					topicList.append(topicElement);
				});
			});
		}
	
		function loadPosts(topicId) {
			console.log("Loading posts for topic ID:", topicId);
			item.server("get_posts_by_topic", [topicId], function (posts, error) {
				if (error) return console.error("Error fetching posts:", error);
				console.log("Received posts:", posts);
				let forumContainer = $("#forum-container");
				if (forumContainer.length === 0) {
					console.warn("#forum-container NOT FOUND! Creating it now...");
					$("body").append('<div id="forum-container"></div>'); // Create container
					forumContainer = $("#forum-container"); // Re-select after adding
				}
				// Remove previous posts section before adding a new one
				$("#simple-posts").remove();
				// Add a new div to display posts
				forumContainer.append("<div id='simple-posts' style='border:1px solid blue; padding:10px; margin-left:8%; margin-right:8%'></div>");
				let postList = $("#simple-posts"); // Select newly created div
				postList.empty(); // Clear old posts
				postList.append("<h3>Posts</h3>"); // This will be the ONLY header
				// Add "New Post" button
				postList.append("<button id='create-post-btn' class='btn btn-primary'>New Post</button>");
				if (posts.length === 0) {
					postList.append("<div>No posts yet. Be the first to post!</div>");
				} else {
					posts.forEach(post => {
						postList.append(`<div><b>${post.author}:</b> ${post.content} <br> <small>${post.created_at}</small></div>`);
					});
				}
				console.log("Posts successfully updated.");
				$("#create-post-btn").click(() => {
					let author = prompt("Enter your name:");
					let content = prompt("Enter post content:");
					if (!author || !content) return;
					console.log(`Attempting to create post for topic: ${topicId}`);
					item.server("create_post", [topicId, author, content], function(response, error) {
						if (error) {
							console.error("Error creating post:", error);
							return;
						}
						if (response.error) {
							console.error("Server Error:", response.error);
						} else {
							console.log("Post created successfully, refreshing posts...");
							loadPosts(topicId);
						}
					});
				});
			});
		}
	
		$("#create-topic-btn").click(() => {
			let title = prompt("Enter topic title:");
			if (!title) return;
			item.server("create_topic", [title], function (response, error) {
				if (error) return console.error("Error creating topic:", error);
				renderTopics();
			});
		});
	
		forumContainer.append($(".topics-view").clone());  // Ensures the topic list is always present
		renderTopics();  // Load topics immediately
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events7 = new Events7();

function Events10() { // jam_forum.catalogs.sqlpage 

	function on_view_form_created(item) {
		// Clone the HTML template
		const template = task.templates.find(".sqlpage-iframe-container").clone();
	
		// Define the SQL code to display (using a template literal for multiline)
		const sqlCode = `
	INSERT INTO JAM_FORUM_POSTS (CONTENT, CREATED_AT, DELETED, AUTHOR, MASTER_REC_ID, MASTER_ID)
	SELECT :Content, :Created_At, :Deleted, :Author, :Master_REC_ID, :Master_ID
	WHERE :Content IS NOT NULL AND $e IS NULL;
	
	-- Update the record when editing
	UPDATE JAM_FORUM_POSTS
	SET CONTENT = :Content, CREATED_AT = :Created_At, DELETED = :Deleted, AUTHOR = :Author, MASTER_REC_ID = :Master_REC_ID, MASTER_ID = :Master_ID 
	WHERE id = $e AND :Content IS NOT NULL;
	
	-- Delete the record
	DELETE FROM JAM_FORUM_POSTS WHERE id = $d;
	
	-- Conditionally show the form for editing or adding a new entry
	SELECT 'form' AS component;
	
	-- Populate form fields for both adding and editing
	SELECT (SELECT CONTENT FROM JAM_FORUM_POSTS WHERE id = $e) AS value, 'Content' AS name;
	SELECT (SELECT CREATED_AT FROM JAM_FORUM_POSTS WHERE id = $e) AS value, 'Created_At' AS name;
	SELECT (SELECT DELETED FROM JAM_FORUM_POSTS WHERE id = $e) AS value, 'Deleted' AS name;
	SELECT (SELECT MASTER_REC_ID FROM JAM_FORUM_POSTS WHERE id = $e) AS value, 'Master_REC_ID' AS name;
	SELECT (SELECT MASTER_ID FROM JAM_FORUM_POSTS WHERE id = $e) AS value, 'Master_ID' AS name;
	SELECT (SELECT AUTHOR FROM JAM_FORUM_POSTS WHERE id = $e) AS value, 'Author' AS name;
	
	-- Add "Add New" button to set the $add parameter
	SELECT 'button' AS component, 'center' AS justify;
	SELECT '?add=1' AS link, 'Clear and Add New' AS title;
	
	-- Display the table with actions
	SELECT 'table' AS component, 
		'Edit' AS markdown, 
		'Remove' AS markdown, 
		TRUE AS sort,
		TRUE AS search;
	
	SELECT  
		id AS ID, 
		CONTENT AS Content, 
		CREATED_AT AS Created_At,
		DELETED AS Deleted,
		AUTHOR AS Author,
		MASTER_REC_ID AS Master_REC_ID,
		MASTER_ID AS Master_ID,
		'[Edit](?e=' || id || ')' AS Edit,
		'[🗑️](?d=' || id || ')' AS Remove
	FROM JAM_FORUM_POSTS;`;
	
		// Find the blank-body element within the cloned template
		const blankBody = template.find(".blank-body");
	
		// Create a textarea element with some styling
		const textarea = $("<textarea></textarea>")
			.css({
				width: "100%",
				height: "400px",
				fontFamily: "monospace",
				fontSize: "12px",
				border: "1px solid #ccc",
				marginTop: "10px",
				padding: "5px",
				boxSizing: "border-box"
			})
			.val(sqlCode)
			.prop("readonly", true); // Make it read-only
	
		// Append the textarea to the blank-body div
		blankBody.append(textarea);
	
		// Delay resetting scroll position to ensure it takes effect
		setTimeout(function() {
			textarea.scrollTop(0);
		}, 50);
	
		// Empty the view_form container and append the updated template
		item.view_form.empty().append(template);
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events10 = new Events10();

function Events11() { // jam_forum.catalogs.ui_grid 

	function on_view_form_created(item) {
		$('#content').empty();
		// $('#content').append($('<div id="controls">'));
		// task.details.posts.view($('#controls'));
		$('#content').append($('<div id="table">'));
		let c = task.details.posts.copy();  // task.details.items[0] // task.details.task.posts.copy();
		c.create_table($('#table'));
		c.open();
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events11 = new Events11();

function Events12() { // jam_forum.catalogs.topic_grid 

	// let item = task.journals.topics.item;
	// let item2 = task.journals.topics.item;
	
	function on_view_form_created(item) {
		$('#content').empty();
		// $('#content').append($('<div id="controls">'));
		// task.journals.topics.view($('#controls'));
		$('#content').append($('<div id="table">'));
		let c = task.journals.topics.copy();   // task.details.items[0] // task.details.task.posts.copy()
		c.create_table($('#table'));
		c.open();
	}
	
	// function on_page_loaded(task) {
		
	//	 $("title").text(task.item_caption);
	//	 $("#title").text(task.item_caption);
		  
	//	 if (task.safe_mode) {
	//		 $("#user-info").text(task.user_info.role_name + ' ' + task.user_info.user_name);
	//		 $('#log-out')
	//		 .show() 
	//		 .click(function(e) {
	//			 e.preventDefault();
	//			 task.logout();
	//		 }); 
	//	 }
	
	//	 if (task.full_width) {
	//		 $('#container').removeClass('container').addClass('container-fluid');
	//	 }
	//	 $('#container').show();
		
	//	 task.create_menu($("#menu"), $("#content"), {
	//		 // splash_screen: '<h1 class="text-center">Application</h1>',
	//		 view_first: true
	//	 });
	
	//	 // $(document).ajaxStart(function() { $("html").addClass("wait"); });
	//	 // $(document).ajaxStop(function() { $("html").removeClass("wait"); });
	// } 
	
	// function on_view_form_created(item) {
	//	 var table_options_height = item.table_options.height,
	//		 table_container;
	
	//	 item.clear_filters();
		
	//	 item.view_options.table_container_class = 'view-table';
	//	 item.view_options.detail_container_class = 'view-detail';
	//	 item.view_options.open_item = true;
		
	//	 if (item.view_form.hasClass('modal')) {
	//		 item.view_options.width = 1060;
	//		 item.table_options.height = $(window).height() - 300;
	//	 }
	//	 else {
	//		 if (!item.table_options.height) {
	//			 item.table_options.height = $(window).height() - $('body').height() - 20;
	//		 }
	//	 }
		
	//	 if (item.can_create()) {
	//		 item.view_form.find("#new-btn").on('click.task', function(e) {
	//			 e.preventDefault();
	//			 if (item.master) {
	//				 item.append_record();
	//			 }
	//			 else {
	//				 item.insert_record();
	//			 }
	//		 });
	//	 }
	//	 else {
	//		 item.view_form.find("#new-btn").prop("disabled", true);
	//	 }
	
	//	 item.view_form.find("#edit-btn").on('click.task', function(e) {
	//		 e.preventDefault();
	//		 item.edit_record();
	//	 });
	
	//	 if (item.can_delete()) {
	//		 item.view_form.find("#delete-btn").on('click.task', function(e) {
	//			 e.preventDefault();
	//			 item.delete_record();
	//		 });
	//	 }
	//	 else {
	//		 item.view_form.find("#delete-btn").prop("disabled", true);
	//	 }
		
	//	 create_print_btns(item);
	
	//	 task.view_form_created(item);
		
	//	 if (!item.master && item.owner.on_view_form_created) {
	//		 item.owner.on_view_form_created(item);
	//	 }
	
	//	 if (item.on_view_form_created) {
	//		 item.on_view_form_created(item);
	//	 }
		
	//	 item.create_view_tables();
		
	//	 if (!item.master && item.view_options.open_item) {
	//		 item.open(true);
	//	 }
	
	//	 if (!table_options_height) {
	//		 item.table_options.height = undefined;
	//	 }
	//	 return true;
	// }
	
	// function on_view_form_shown(item) {
	//	 item.view_form.find('.dbtable.' + item.item_name + ' .inner-table').focus();
	// }
	
	// function on_view_form_closed(item) {
	//	 if (!item.master && item.view_options.open_item) {	
	//		 item.close();
	//	 }
	// }
	
	// function on_edit_form_created(item) {
	//	 item.edit_options.inputs_container_class = 'edit-body';
	//	 item.edit_options.detail_container_class = 'edit-detail';
		
	//	 item.edit_form.find("#cancel-btn").on('click.task', function(e) { item.cancel_edit(e) });
	//	 item.edit_form.find("#ok-btn").on('click.task', function() { item.apply_record() });
	//	 if (!item.is_new() && !item.can_modify) {
	//		 item.edit_form.find("#ok-btn").prop("disabled", true);
	//	 }
		
	//	 task.edit_form_created(item);
		
	//	 if (!item.master && item.owner.on_edit_form_created) {
	//		 item.owner.on_edit_form_created(item);
	//	 }
	
	//	 if (item.on_edit_form_created) {
	//		 item.on_edit_form_created(item);
	//	 }
			
	//	 item.create_inputs(item.edit_form.find('.' + item.edit_options.inputs_container_class));
	//	 item.create_detail_views(item.edit_form.find('.' + item.edit_options.detail_container_class));
	
	//	 return true;
	// }
	
	// function on_edit_form_close_query(item) {
	//	 var result = true;
	//	 if (item.is_changing()) {
	//		 if (item.is_modified()) {
	//			 item.yes_no_cancel(task.language.save_changes,
	//				 function() {
	//					 item.apply_record();
	//				 },
	//				 function() {
	//					 item.cancel_edit();
	//				 }
	//			 );
	//			 result = false;
	//		 }
	//		 else {
	//			 item.cancel_edit();
	//		 }
	//	 }
	//	 return result;
	// }
	
	// function on_filter_form_created(item) {
	//	 item.filter_options.title = item.item_caption + ' - filters';
	//	 item.create_filter_inputs(item.filter_form.find(".edit-body"));
	//	 item.filter_form.find("#cancel-btn").on('click.task', function() {
	//		 item.close_filter_form(); 
	//	 });
	//	 item.filter_form.find("#ok-btn").on('click.task', function() { 
	//		 item.set_order_by(item.view_options.default_order);
	//		 item.apply_filters(item._search_params); 
	//	 });
	// }
	
	// function on_param_form_created(item) {
	//	 item.create_param_inputs(item.param_form.find(".edit-body"));
	//	 item.param_form.find("#cancel-btn").on('click.task', function() { 
	//		 item.close_param_form();
	//	 });
	//	 item.param_form.find("#ok-btn").on('click.task', function() { 
	//		 item.process_report();
	//	 });
	// }
	
	// function on_before_print_report(report) {
	//	 var select;
	//	 report.extension = 'pdf';
	//	 if (report.param_form) {
	//		 select = report.param_form.find('select');
	//		 if (select && select.val()) {
	//			 report.extension = select.val();
	//		 }
	//	 }
	// }
	
	// function on_view_form_keyup(item, event) {
	//	 if (event.keyCode === 45 && event.ctrlKey === true){
	//		 if (item.master) {
	//			 item.append_record();
	//		 }
	//		 else {
	//			 item.insert_record();				
	//		 }
	//	 }
	//	 else if (event.keyCode === 46 && event.ctrlKey === true){
	//		 item.delete_record(); 
	//	 }
	// }
	
	// function on_edit_form_keyup(item, event) {
	//	 if (event.keyCode === 13 && event.ctrlKey === true){
	//		 item.edit_form.find("#ok-btn").focus(); 
	//		 item.apply_record();
	//	 }
	// }
	
	// function create_print_btns(item) {
	//	 var i,
	//		 $ul,
	//		 $li,
	//		 reports = [];
	//	 if (item.reports) {
	//		 for (i = 0; i < item.reports.length; i++) {
	//			 if (item.reports[i].can_view()) {
	//				 reports.push(item.reports[i]);
	//			 }
	//		 }
	//		 if (reports.length) {
	//			 $ul = item.view_form.find("#report-btn ul");
	//			 for (i = 0; i < reports.length; i++) {
	//				 $li = $('<li><a href="#">' + reports[i].item_caption + '</a></li>');
	//				 $li.find('a').data('report', reports[i]);
	//				 $li.on('click', 'a', function(e) {
	//					 e.preventDefault();
	//					 $(this).data('report').print(false);
	//				 });
	//				 $ul.append($li);
	//			 }
	//		 }
	//		 else {
	//			 item.view_form.find("#report-btn").hide();
	//		 }
	//	 }
	//	 else {
	//		 item.view_form.find("#report-btn").hide();
	//	 }
	// }
	this.on_view_form_created = on_view_form_created;
}

task.events.events12 = new Events12();

function Events14() { // jam_forum.journals.grapes 

	function on_view_form_created(item) {
		const template = task.templates.find(".grapeslayout").clone();
		item.view_form.empty().append(template);
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events14 = new Events14();

function Events15() { // jam_forum.catalogs.test 

	function on_view_form_created(item) {
		const template = task.templates.find(".test").clone();
		item.view_form.empty().append(template);
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events15 = new Events15();

})(jQuery, task)