(function($, task) {
"use strict";

function Events1() { // jam_form 

	function on_page_loaded(task) {
		
		$("title").text(task.item_caption);
		$("#title").text(task.item_caption);
		  
		if (task.safe_mode) {
			$("#user-info").text(task.user_info.role_name + ' ' + task.user_info.user_name);
			$('#log-out')
			.show() 
			.click(function(e) {
				e.preventDefault();
				task.logout();
			}); 
		}
	
		if (task.full_width) {
			$('#container').removeClass('container').addClass('container-fluid');
		}
		$('#container').show();
		
		task.create_menu($("#menu"), $("#content"), {
			// splash_screen: '<h1 class="text-center">Application</h1>',
			view_first: true
		});
	
		// $(document).ajaxStart(function() { $("html").addClass("wait"); });
		// $(document).ajaxStop(function() { $("html").removeClass("wait"); });
	} 
	
	function on_view_form_created(item) {
		var table_options_height = item.table_options.height,
			table_container;
	
		item.clear_filters();
		
		item.view_options.table_container_class = 'view-table';
		item.view_options.detail_container_class = 'view-detail';
		item.view_options.open_item = true;
		
		if (item.view_form.hasClass('modal')) {
			item.view_options.width = 1060;
			item.table_options.height = $(window).height() - 300;
		}
		else {
			if (!item.table_options.height) {
				item.table_options.height = $(window).height() - $('body').height() - 20;
			}
		}
		
		if (item.can_create()) {
			item.view_form.find("#new-btn").on('click.task', function(e) {
				e.preventDefault();
				if (item.master) {
					item.append_record();
				}
				else {
					item.insert_record();
				}
			});
		}
		else {
			item.view_form.find("#new-btn").prop("disabled", true);
		}
	
		item.view_form.find("#edit-btn").on('click.task', function(e) {
			e.preventDefault();
			item.edit_record();
		});
	
		if (item.can_delete()) {
			item.view_form.find("#delete-btn").on('click.task', function(e) {
				e.preventDefault();
				item.delete_record();
			});
		}
		else {
			item.view_form.find("#delete-btn").prop("disabled", true);
		}
		
		create_print_btns(item);
	
		task.view_form_created(item);
		
		if (!item.master && item.owner.on_view_form_created) {
			item.owner.on_view_form_created(item);
		}
	
		if (item.on_view_form_created) {
			item.on_view_form_created(item);
		}
		
		item.create_view_tables();
		
		if (!item.master && item.view_options.open_item) {
			item.open(true);
		}
	
		if (!table_options_height) {
			item.table_options.height = undefined;
		}
		return true;
	}
	
	function on_view_form_shown(item) {
		item.view_form.find('.dbtable.' + item.item_name + ' .inner-table').focus();
	}
	
	function on_view_form_closed(item) {
		if (!item.master && item.view_options.open_item) {	
			item.close();
		}
	}
	
	function on_edit_form_created(item) {
		item.edit_options.inputs_container_class = 'edit-body';
		item.edit_options.detail_container_class = 'edit-detail';
		
		item.edit_form.find("#cancel-btn").on('click.task', function(e) { item.cancel_edit(e) });
		item.edit_form.find("#ok-btn").on('click.task', function() { item.apply_record() });
		if (!item.is_new() && !item.can_modify) {
			item.edit_form.find("#ok-btn").prop("disabled", true);
		}
		
		task.edit_form_created(item);
		
		if (!item.master && item.owner.on_edit_form_created) {
			item.owner.on_edit_form_created(item);
		}
	
		if (item.on_edit_form_created) {
			item.on_edit_form_created(item);
		}
			
		item.create_inputs(item.edit_form.find('.' + item.edit_options.inputs_container_class));
		item.create_detail_views(item.edit_form.find('.' + item.edit_options.detail_container_class));
	
		return true;
	}
	
	function on_edit_form_close_query(item) {
		var result = true;
		if (item.is_changing()) {
			if (item.is_modified()) {
				item.yes_no_cancel(task.language.save_changes,
					function() {
						item.apply_record();
					},
					function() {
						item.cancel_edit();
					}
				);
				result = false;
			}
			else {
				item.cancel_edit();
			}
		}
		return result;
	}
	
	function on_filter_form_created(item) {
		item.filter_options.title = item.item_caption + ' - filters';
		item.create_filter_inputs(item.filter_form.find(".edit-body"));
		item.filter_form.find("#cancel-btn").on('click.task', function() {
			item.close_filter_form(); 
		});
		item.filter_form.find("#ok-btn").on('click.task', function() { 
			item.set_order_by(item.view_options.default_order);
			item.apply_filters(item._search_params); 
		});
	}
	
	function on_param_form_created(item) {
		item.create_param_inputs(item.param_form.find(".edit-body"));
		item.param_form.find("#cancel-btn").on('click.task', function() { 
			item.close_param_form();
		});
		item.param_form.find("#ok-btn").on('click.task', function() { 
			item.process_report();
		});
	}
	
	function on_before_print_report(report) {
		var select;
		report.extension = 'pdf';
		if (report.param_form) {
			select = report.param_form.find('select');
			if (select && select.val()) {
				report.extension = select.val();
			}
		}
	}
	
	function on_view_form_keyup(item, event) {
		if (event.keyCode === 45 && event.ctrlKey === true){
			if (item.master) {
				item.append_record();
			}
			else {
				item.insert_record();				
			}
		}
		else if (event.keyCode === 46 && event.ctrlKey === true){
			item.delete_record(); 
		}
	}
	
	function on_edit_form_keyup(item, event) {
		if (event.keyCode === 13 && event.ctrlKey === true){
			item.edit_form.find("#ok-btn").focus(); 
			item.apply_record();
		}
	}
	
	function create_print_btns(item) {
		var i,
			$ul,
			$li,
			reports = [];
		if (item.reports) {
			for (i = 0; i < item.reports.length; i++) {
				if (item.reports[i].can_view()) {
					reports.push(item.reports[i]);
				}
			}
			if (reports.length) {
				$ul = item.view_form.find("#report-btn ul");
				for (i = 0; i < reports.length; i++) {
					$li = $('<li><a href="#">' + reports[i].item_caption + '</a></li>');
					$li.find('a').data('report', reports[i]);
					$li.on('click', 'a', function(e) {
						e.preventDefault();
						$(this).data('report').print(false);
					});
					$ul.append($li);
				}
			}
			else {
				item.view_form.find("#report-btn").hide();
			}
		}
		else {
			item.view_form.find("#report-btn").hide();
		}
	}
	this.on_page_loaded = on_page_loaded;
	this.on_view_form_created = on_view_form_created;
	this.on_view_form_shown = on_view_form_shown;
	this.on_view_form_closed = on_view_form_closed;
	this.on_edit_form_created = on_edit_form_created;
	this.on_edit_form_close_query = on_edit_form_close_query;
	this.on_filter_form_created = on_filter_form_created;
	this.on_param_form_created = on_param_form_created;
	this.on_before_print_report = on_before_print_report;
	this.on_view_form_keyup = on_view_form_keyup;
	this.on_edit_form_keyup = on_edit_form_keyup;
	this.create_print_btns = create_print_btns;
}

task.events.events1 = new Events1();

function Events7() { // jam_form.journals.custom_form 

	function on_view_form_created(item) {
		const template = task.templates.find(".custom-form").clone();
		item.view_form.empty().append(template);
		$("#ifv3g").submit(function (event) {
			event.preventDefault(); // Prevent default page reload
			let c = task.form_tables.copy();
			c.open();
			c.append();
			c.text.value=$("#multi-text").val();
			c.email.value=$("#multi-email").val();
			c.password.value=$("#multi-password").val();
			c.gender.value=$("input[name='gender']:checked").val() || null;
			c.options.value=$("#multi-select").val();
			c.date.value = $("#multi-date").val() ? new Date($("#multi-date").val() + "T00:00:00") : null;
			c.number.value=$("#multi-number").val();
			c.created_at.value=new Date();
			c.post();
			c.apply();
		});
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	// c.date.value=$("#multi-date").val();
			// c.date.value = selectedDate ? new Date(selectedDate).toISOString().slice(0, 19).replace("T", " ") : null;
	
			// // Collect form values using jQuery
			// let formData = {
			//	 text: $("#multi-text").val(),
			//	 email: $("#multi-email").val(),
			//	 password: $("#multi-password").val(),
			//	 gender: $("input[name='gender']:checked").val() || null,
			//	 option: $("#multi-select").val(),
			//	 date: $("#multi-date").val(),
			//	 number: $("#multi-number").val()
			// };
			// console.log("Saving form data:", formData);
			
			// console.log("Sending form data to backend:", formData);
	
			// // Send data to the backend using item.server() // CALL FUNCTION ON TASK.FORM_TABLES
			// // task.form_tables.server("save_form_values", [formData], function (response, error) {
			// item.server("save_form_values", [formData], function (response, error) {
			//	 if (error) {
			//		 console.error("Error saving form data:", error);
			//		 alert("Error saving form data. Check console for details.");
			//		 return;
			//	 }
	
			//	 console.log("Response from backend:", response);
			//	 alert("Form data saved successfully!");
			// });
	this.on_view_form_created = on_view_form_created;
}

task.events.events7 = new Events7();

function Events8() { // jam_form.journals.calculations 

	function on_field_changed(field, lookup_item) {
		field.owner.difference.value = (
			field.owner.end_date.value - field.owner.start_date.value
		) / (1000 * 60 * 60 * 24);
	}
	
	function on_field_validate(field) {
		if (field.owner.end_date.value < field.owner.start_date.value) {
			return "End date must be later than start date";
		}
	}
	this.on_field_changed = on_field_changed;
	this.on_field_validate = on_field_validate;
}

task.events.events8 = new Events8();

function Events11() { // jam_form.journals.cash_register_receipts.cash_register 

	function on_field_changed(field, lookup_item) {
		field.owner.quantity_price.value = (
			field.owner.price.value * field.owner.quantity.value * 1.06
		);
	}
	
	function on_field_validate(field) {
		if (field.owner.price.value < 0) {
			return "Price must be positive";
		}
	}
	this.on_field_changed = on_field_changed;
	this.on_field_validate = on_field_validate;
}

task.events.events11 = new Events11();

function Events12() { // jam_form.journals.coin_toss 

	// function on_view_form_created(item) {
	//	 const template = task.templates.find(".cointoss").clone();
	//	 item.view_form.empty().append(template);
		
	//	 $("#coinform").submit(function (event) {
	//		 console.log("Flipping...");
	//		 event.preventDefault(); // Prevent the form from submitting
	//		 $("#coinimage").attr("src", "./static/files/tails_2025-02-08_17-43-48_211693.jpg");
	//	 });
	// }
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
			// let coinholderdiv = $("#coinholderdiv");
			// event.preventDefault();
			// coinholderdiv.empty();
			// // topics.forEach(topic => {
			// let coinimage = $("<img>")
			//	 .addClass("coinimg")
			//	 .src("./static/files/heads_2025-02-08_17-43-34_191100.jpg");
			//	 // .data("topic-id", topic.id)
			// coinholderdiv.append(coinimage);
			// });
			// let c = task.image.copy();
			// task.coin_toss.image.raw_value
			// <img id="coinimage" src="./static/files/heads_2025-02-08_17-43-34_191100.jpg">
	
	
	
	// function on_view_form_created(item) {
	//	 let forumContainer = $("#forum-container");
	//	 function renderTopics() {
	//		 item.server("get_all_topics", function (topics, error) {
	//			 if (error) return console.error("Error fetching topics:", error);
	//			 let topicList = $("#topic-list");
	//			 topicList.empty();
	//			 topics.forEach(topic => {
	//				 let topicElement = $("<li>")
	//					 .addClass("list-group-item forum-topic")
	//					 .text(topic.title)
	//					 .data("topic-id", topic.id)
	//					 .click(() => loadPosts(topic.id));  // Click loads posts but doesn't hide topics
	//				 topicList.append(topicElement);
	//			 });
	//		 });
	//	 }
	//	 renderTopics();
	// }
}

task.events.events12 = new Events12();

function Events13() { // jam_form.journals.coin_toss_ui 

	function on_view_form_created(item) {
		const template = task.templates.find(".cointoss").clone();
		item.view_form.empty().append(template);
		
		$("#coinform").submit(function (event) {
			event.preventDefault();
			const images = [
				"./static/files/tails_2025-02-08_17-43-48_211693.jpg",
				"./static/files/heads_2025-02-08_17-43-34_191100.jpg"
			];
			const randomImage = images[Math.floor(Math.random() * images.length)];
			$("#coinimage").attr("src", randomImage);
			console.log("Flipped to:  " + randomImage);
		});
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events13 = new Events13();

function Events14() { // jam_form.journals.display_api_response 

	function on_view_form_created(item) {
		// Clone the template that contains the repeating panel container
		const template = task.templates.find(".api-repeating-panel").clone();
		item.view_form.empty().append(template);
		
		function renderLayout() {
			item.server("get_json_data", function (rows, error) {
				if (error) {
					console.error("Error fetching topics:", error);
					return;
				}
				
				// Find the repeating panel container within the view form
				let repeatingPanel = item.view_form.find(".api-repeating-panel");
				repeatingPanel.empty();
				
				// Loop through each user (row) and create a detailed card.
				rows.forEach(rowItem => {
					// Create the main card container with additional custom styling
					let card = $("<div>")
						.addClass("card custom-card mb-4")
						.data("rowItem-id", rowItem.id);
					
					// Card header with a gradient background displaying the name and username
					let cardHeader = $("<div>")
						.addClass("card-header")
						.html(`<h4>${rowItem.name}</h4>
							   <small>@${rowItem.username}</small>`);
					
					// Card body for the main details
					let cardBody = $("<div>").addClass("card-body");
					
					// Basic user details: email, phone, and website
					cardBody.append(`
						<p class="card-text"><strong>Email:</strong> ${rowItem.email}</p>
						<p class="card-text"><strong>Phone:</strong> ${rowItem.phone}</p>
						<p class="card-text">
							<strong>Website:</strong> 
							<a href="http://${rowItem.website}" target="_blank">${rowItem.website}</a>
						</p>
					`);
					
					// Address details from the nested address object
					const addr = rowItem.address;
					cardBody.append(`
						<div class="address">
							<p class="card-text"><strong>Address:</strong> ${addr.street}, ${addr.suite}</p>
							<p class="card-text">${addr.city}, ${addr.zipcode}</p>
							<p class="card-text"><small>Geo: lat ${addr.geo.lat}, lng ${addr.geo.lng}</small></p>
						</div>
					`);
					
					// Company details from the nested company object
					const comp = rowItem.company;
					cardBody.append(`
						<div class="company">
							<p class="card-text"><strong>Company:</strong> ${comp.name}</p>
							<p class="card-text"><em>"${comp.catchPhrase}"</em></p>
							<p class="card-text">${comp.bs}</p>
						</div>
					`);
					
					// Assemble the card
					card.append(cardHeader);
					card.append(cardBody);
					// Append the card to the repeating panel container
					repeatingPanel.append(card);
				});
			});
		}
		
		renderLayout();
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	// First working styled version
	
	// function on_view_form_created(item) {
	//	 // Clone the template containing the repeating panel container
	//	 const template = task.templates.find(".api-repeating-panel").clone();
	//	 item.view_form.empty().append(template);
		
	//	 function renderLayout() {
	//		 item.server("get_json_data", function (rows, error) {
	//			 if (error) {
	//				 console.error("Error fetching topics:", error);
	//				 return;
	//			 }
				
	//			 // Find the repeating panel container within the view form
	//			 let repeatingPanel = item.view_form.find(".api-repeating-panel");
	//			 repeatingPanel.empty();
				
	//			 // Create a card for each row returned by the API
	//			 rows.forEach(rowItem => {
	//				 // Create a card container and add custom styling classes
	//				 let card = $("<div>")
	//					 .addClass("card custom-card mb-3");  // 'custom-card' is our extra class for styling
					
	//				 let cardBody = $("<div>").addClass("card-body");
					
	//				 $("<h5>")
	//					 .addClass("card-title")
	//					 .text(rowItem.name)
	//					 .appendTo(cardBody);
					
	//				 $("<p>")
	//					 .addClass("card-text")
	//					 .text(`Username: ${rowItem.username}`)
	//					 .appendTo(cardBody);
					
	//				 $("<p>")
	//					 .addClass("card-text")
	//					 .text(`Email: ${rowItem.email}`)
	//					 .appendTo(cardBody);
					
	//				 card.data("rowItem-id", rowItem.id);
	//				 card.append(cardBody);
	//				 repeatingPanel.append(card);
	//			 });
	//		 });
	//	 }
		
	//	 renderLayout();
	// }
	
	
	
	// First fully working version
	
	// function on_view_form_created(item) {
	//	 // Clone the template (which is expected to contain the repeating panel container)
	//	 const template = task.templates.find(".api-repeating-panel").clone();
	//	 // Empty the view form and append the template
	//	 item.view_form.empty().append(template);
		
	//	 // Function to render the layout by fetching data from the server
	//	 function renderLayout() {
	//		 // Call the server-side function used to collect data from the REST API endpoint
	//		 item.server("get_json_data", function (rows, error) {
	//			 if (error) {
	//				 console.error("Error fetching topics:", error);
	//				 return;
	//			 }
				
	//			 // Find the repeating panel container within the current view form.
	//			 // (We assume that the template we cloned has the class "api-repeating-panel")
	//			 let repeatingPanel = item.view_form.find(".api-repeating-panel");
	//			 // Clear any existing content
	//			 repeatingPanel.empty();
				
	//			 // Loop over each row returned from the API call and build a card for it.
	//			 rows.forEach(rowItem => {
	//				 // Create a card container; you can style with your CSS classes (e.g. Bootstrap's card)
	//				 let card = $("<div>").addClass("card mb-3");
					
	//				 // Create a card body
	//				 let cardBody = $("<div>").addClass("card-body");
					
	//				 // Populate the card with data from the row.
	//				 // (For example, using 'name', 'username', and 'email'. Adjust as necessary.)
	//				 $("<h5>")
	//					 .addClass("card-title")
	//					 .text(rowItem.name)
	//					 .appendTo(cardBody);
					
	//				 $("<p>")
	//					 .addClass("card-text")
	//					 .text(`Username: ${rowItem.username}`)
	//					 .appendTo(cardBody);
					
	//				 $("<p>")
	//					 .addClass("card-text")
	//					 .text(`Email: ${rowItem.email}`)
	//					 .appendTo(cardBody);
					
	//				 // If needed, you can store extra data on the card (e.g., row id)
	//				 card.data("rowItem-id", rowItem.id);
					
	//				 // Append the card body to the card
	//				 card.append(cardBody);
	//				 // Append the complete card to the repeating panel container
	//				 repeatingPanel.append(card);
	//			 });
	//		 });
	//	 }
		
	//	 // Initially render the layout
	//	 renderLayout();
	// }
	
	
	
	// Starting point, but not working
	
	// function on_view_form_created(item) {
	//	 const template = task.templates.find(".api-repeating-panel").clone();
	//	 item.view_form.empty().append(template);
		
	//	 function renderLayout() {
	//		 item.server("get_json_data", function (rows, error) {
	//			 if (error) return console.error("Error fetching topics:", error);
	//			 let repeatingPanel = $("#api-repeating-panel");
	//			 repeatingPanel.empty();
	//			 rows.forEach(rowItem => {
	//				 let rowPanel = $("<li>")
	//					 .addClass("sub-item row-item")
	//					 .text(rowItem.title)
	//					 .data("rowItem-id", rowItem.id);
	//					 // .click(() => loadPosts(rowPanel.id));  // ficticious click handler
	//				 repeatingPanel.append(rowPanel);
	//			 });
	//		 });
	//	 }
	//	 renderLayout();
	// }
	this.on_view_form_created = on_view_form_created;
}

task.events.events14 = new Events14();

function Events15() { // jam_form.journals.web_cams 

	function on_view_form_created(item) {
		// Clone the template that contains the webcam-repeating-panel
		const template = task.templates.find(".webcam-repeating-panel").clone();
		item.view_form.empty().append(template);
		
		function renderLayout() {
			const baseUrl = "https://cwwp2.dot.ca.gov/data/d2/cctv/image/";
			const imagePaths = [
				"pitriverbridge/pitriverbridge.jpg",
				// "johnsongrade/johnsongrade.jpg",
				// "perez/perez.jpg",
				"mthebron/mthebron.jpg",
				"eurekaway/eurekaway.jpg",
				"sr70us395/sr70us395.jpg",
				"bogard/bogard.jpg",
				"eastriverside/eastriverside.jpg",
			];
	
			let repeatingPanel = item.view_form.find(".webcam-repeating-panel");
			repeatingPanel.empty();
			
			imagePaths.forEach(camurl => {
				let fullImageUrl = baseUrl + camurl;
	
				let card = $("<div>").addClass("card webcam-card mb-4");
	
				let imgElement = $("<img>")
					.attr("src", fullImageUrl)
					.attr("alt", "Traffic Camera")
					.addClass("card-img-top");
	
				let cardBody = $("<div>").addClass("card-body");
				cardBody.append(`<p class="card-text">${camurl.split("/")[0]}</p>`);
	
				card.append(imgElement);
				card.append(cardBody);
				repeatingPanel.append(card);
			});
		}
		
		renderLayout();
	}
	this.on_view_form_created = on_view_form_created;
}

task.events.events15 = new Events15();

function Events16() { // jam_form.journals.weather_api 

	function on_field_changed(field, lookup_item) {
		let zipCode = field.value; // Get the entered zip code
	
		field.owner.server("get_weather", zipCode, function (weatherData, error) {
			if (error) {
				console.error("Error fetching weather data:", error);
				return;
			}
	
			if (weatherData) {
				// Update the fields with fetched temperature and wind speed
				field.owner.temperature.value = weatherData.temp;
				field.owner.wind_speed.value = weatherData.wind_speed;
			} else {
				console.warn("No weather data received.");
			}
		});
	}
	this.on_field_changed = on_field_changed;
}

task.events.events16 = new Events16();

function Events17() { // jam_form.journals.age_guess_api 

	function on_field_changed(field, lookup_item) {
		let name = field.value; // Get the entered name
		field.owner.server("guess_age", name, function (age, error) {
			if (age) {
				field.owner.guessed_age.value = age;
			}
		});
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	// function on_field_changed(field, lookup_item) {
	//	 field.owner.server("guess_age", field.value, function (age, error) {
	//		 field.owner.guessed_age.value = age;
	//	 });
	// }
	
	
	
	// function on_after_edit(item) {
	//	 let person = String(item.name); // Ensure name is a plain string
	//	 item.server("guess_age", person, function (age, error) {
	//		 if (error) {
	//			 console.error("Error fetching age:", error);
	//			 return;
	//		 }
	//		 item.guessed_age.value = age; // Assign the returned age
	//	 });
	// }
	
	
	
	// function on_edit_form_closed(item) {
	//	 let person = String(item.name); // Ensure name is a plain string
	//	 item.server("guess_age", person, function (age, error) {
	//		 if (error) {
	//			 console.error("Error fetching age:", error);
	//			 return;
	//		 }
	//		 item.guessed_age.value = age; // Assign the returned age
	//	 });
	// }
	
	// function on_edit_form_closed(item) {
	//	 let name = item.name;
	//	 item.server("guess_age", name, function (age, error) {
	//		 item.guessed_age.value = age;
	//	 });
	// }
	
	// function on_field_changed(field, lookup_item) {
	//	 let name = field.value; // Get the entered name
	//	 field.owner.server("guess_age", name, function (age, error) {
	//		 if (age) {
	//			 field.owner.guessed_age.value = age;
	//		 } else {
	//			 console.warn("No age value received.");
	//		 }
	//	 });
	// }
	this.on_field_changed = on_field_changed;
}

task.events.events17 = new Events17();

})(jQuery, task)